import sql from 'mssql';
import { config } from './config.js';

export const updateAuthor = async (id, firstName) => {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Update the First Name
    const result = await pool
      .request()
      .input('id', sql.Int, id)
      .input('firstName', sql.VarChar, firstName)
      .query(`UPDATE Authors SET FirstName =@firstName WHERE AuthorID=@id`);

    if (result.rowsAffected.length >= 1) {
      console.log(`${result.rowsAffected.length} row(s) updated!`);
    }
  } catch (err) {
    console.error(err);
  }
};
